#version 300 es

in vec4 aPosition;
in vec2 aTextureCoord;

uniform vec2 uTexelSize;
uniform float uOffsets;      // 只保留一个偏移值
uniform float uUpsetDown;      // 只保留一个偏移值

out vec2 vUV;
out vec4 vUVs[2];  // 只保留一组UV

const float EXTEND = 0.08;

void calculateUVs(float offset, out vec4 uvs[2], vec2 uv, vec2 texelSize) {
    vec2 _offset = vec2(1.0 + offset, 1.0 + offset);
    
    uvs[0] = vec4(
        uv - texelSize * _offset,
        uv + texelSize * _offset
    );
    uvs[0] = clamp(uvs[0], 0.0, 1.0);

    uvs[1] = vec4(
        uv - vec2(texelSize.x, -texelSize.y) * _offset,
        uv + vec2(texelSize.x, -texelSize.y) * _offset
    );
    uvs[1] = clamp(uvs[1], 0.0, 1.0);
}

void main() {
    vec2 uv = vec2(aTextureCoord.x, 1.0 - aTextureCoord.y);
    vec2 _texelSize = uTexelSize * 0.5;
    
    // 只计算一个矩形的UV采样坐标
    calculateUVs(uOffsets, vUVs, uv, _texelSize);

    gl_Position = aPosition;
    vUV = uv;
}