#version 300 es
precision mediump float;

uniform sampler2D uPassTex;

in vec2 vTexCoord;
in vec2 vBlurTexCoords[5];

out vec4 fragColor;

void main() {
    // 高斯权重 (σ = 2.3)
    const float weight[5] = float[](0.164074, 0.216901, 0.23805, 0.216901, 0.164074);
    
    // 中心点采样
    vec4 sum = texture(uPassTex, vBlurTexCoords[2]) * weight[2];
    
    // 左右/上下采样点
    sum += texture(uPassTex, vBlurTexCoords[1]) * weight[1];
    sum += texture(uPassTex, vBlurTexCoords[3]) * weight[1];
    
    // 最外侧采样点
    sum += texture(uPassTex, vBlurTexCoords[0]) * weight[0];
    sum += texture(uPassTex, vBlurTexCoords[4]) * weight[0];
    
    fragColor = sum;
}