#version 300 es

in vec4 aPosition;
in vec2 aTextureCoord;

uniform vec2 uDirection;      // 模糊方向
uniform float uBlurOffset;    // 模糊偏移量

out vec2 vTexCoord;
out vec2 vBlurTexCoords[5];  // 5个采样点的坐标

void main() {
    gl_Position = aPosition;
    vTexCoord = aTextureCoord;
    
    // 预计算5个采样点的坐标
    vBlurTexCoords[0] = vTexCoord + (-2.0 * uBlurOffset) * uDirection;
    vBlurTexCoords[1] = vTexCoord + (-1.0 * uBlurOffset) * uDirection;
    vBlurTexCoords[2] = vTexCoord;
    vBlurTexCoords[3] = vTexCoord + ( 1.0 * uBlurOffset) * uDirection;
    vBlurTexCoords[4] = vTexCoord + ( 2.0 * uBlurOffset) * uDirection;
}