#version 300 es
precision highp float;

in vec2 v_originTexCoord;

uniform float uAspectRatio;
uniform vec4 uRectBounds; // 矩形边界：x = 左，y = 右，z = 顶，w = 底（范围 [0,1]）
uniform float uRectRadius; // 圆角半径（范围 [0,1]，相对屏幕大小）
uniform float uRectExpand;

out vec4 fragColor;

// 计算点到圆角矩形的有符号距离
float roundedRectSDF(vec2 position, vec2 center, vec2 size, float radius) {
    vec2 q = abs(position - center) - size + vec2(radius);
    return length(max(q, 0.0)) + min(max(q.x, q.y), 0.0) - radius;
}

void main() {
    // 将坐标转换为以矩形中心为原点的坐标系
    vec2 rectCenter = vec2(
        (uRectBounds.x + uRectBounds.y) * 0.5,
        (uRectBounds.w + uRectBounds.z) * 0.5
    );
    vec2 rectSize = vec2(
        (uRectBounds.y - uRectBounds.x) * 0.5,
        (uRectBounds.z - uRectBounds.w) * 0.5
    );

    vec2 position = vec2(v_originTexCoord.x, v_originTexCoord.y / uAspectRatio);
    
    // 计算SDF（注意这里直接传入所有参数）
    float d = roundedRectSDF(position, rectCenter, rectSize, uRectRadius);

    // 边框宽度
    float strokeWidth = 0.035;

    // 使用SDF创建边框
    float strokeMask = 1.0 - smoothstep(0.0, 0.001, abs(d) - strokeWidth * 0.5);
    float outsideMask = 1.0 - smoothstep(0.0, 0.001, -d);

    // 组合颜色
    vec4 strokeColor = vec4(0.0, 0.0, 0.0, strokeMask);
    vec4 outsideColor = vec4(0.0, 0.0, 0.0, outsideMask); // 外部黑色

    fragColor = mix(strokeColor, outsideColor, outsideMask);
}