#version 300 es

precision highp float;

in vec2 v_originTexCoord;

uniform float uAspectRatio;
uniform vec4 uRectBounds; // 矩形边界：x = 左，y = 右，z = 顶，w = 底（范围 [0,1]）
uniform float uRectRadius; // 圆角半径（范围 [0,1]，相对屏幕大小）

out vec4 fragColor;

void main() {

    vec2 fragCoord = vec2(v_originTexCoord.x, v_originTexCoord.y / uAspectRatio);

    // 计算矩形的宽度和高度
    float rectWidth = uRectBounds.y - uRectBounds.x;
    float rectHeight = uRectBounds.z - uRectBounds.w;
    
    // 限制圆角半径不超过矩形最短边的一半
    float maxRadius = min(rectWidth, rectHeight) * 0.5;
    float clampedRadius = min(uRectRadius, maxRadius);
    
    vec2 clampedPos = fragCoord;
    clampedPos.x = max(uRectBounds.x + clampedRadius, min(uRectBounds.y - clampedRadius, fragCoord.x));
    clampedPos.y = max(uRectBounds.w + clampedRadius, min(uRectBounds.z - clampedRadius, fragCoord.y));

    float dist = length(fragCoord - clampedPos);
    float smoothEdge = smoothstep(clampedRadius, clampedRadius + 0.01, dist);
    fragColor = vec4(0.0, 0.0, 0.0, 1.0 - smoothEdge);
}
