#version 300 es

// 高精度浮点数: 圆角显示更好
precision highp float;

in vec2 v_originTexCoord;
in vec2 v_fragCoord;
in vec2 v_bgMappedCoord;
in vec2 v_mappedCoord;
in vec2 v_mappedCoordRev;
in vec2 v_ibgMappedCoord;
in vec2 v_rectCenter;
in vec2 v_rectSize;
in float v_rectRadius;

uniform sampler2D uPassTex;
uniform sampler2D uBgShadowTex;
uniform sampler2D uIconShadowTex;
uniform sampler2D uIconOutlineTex;
uniform sampler2D uBgInnerShadowTex;

uniform float rate;
uniform float transparency;
uniform vec3 blurColor;
uniform float dockBrightness;
uniform float uShowIconEffect;
uniform float uShowBgShadow;
uniform float uShowBgInnerShadow;
uniform float uBgShadowIntensity;
uniform float uBgInnerShadowIntensity;
uniform float uShowBorder;
uniform float uBgBorderWidth;
uniform vec4 uBgBorderColor;

out vec4 fragColor;

float roundedRectSDF(vec2 position, vec2 center, vec2 size, float radius) {
    return length(max(abs(position - center) - size + radius, 0.0)) - radius;
}

void main() {
    vec4 passTex = texture(uPassTex, v_originTexCoord);

    //  rectangle
    float dist = roundedRectSDF(v_fragCoord, v_rectCenter, v_rectSize, v_rectRadius);
    float edgeSoftness = 0.001;
    float shape = 1.0 - smoothstep(-edgeSoftness, edgeSoftness, dist);

    vec4 finalColor = vec4(passTex.rgb, 0.0);

    vec4 dockColor = mix(vec4(blurColor, 1.0), passTex * dockBrightness, transparency);
    finalColor = mix(finalColor, dockColor, shape);

    vec4 bgShadow = texture(uBgShadowTex, v_bgMappedCoord);
    finalColor = mix(bgShadow * uShowBgShadow * uBgShadowIntensity, finalColor, finalColor.a);

    vec4 innerShadowTex = texture(uBgInnerShadowTex, v_ibgMappedCoord);
    finalColor = vec4(mix(finalColor.rgb, innerShadowTex.rgb, shape * innerShadowTex.a
    * uShowBgInnerShadow * uBgInnerShadowIntensity), finalColor.a);

    vec4 iconShadow = texture(uIconShadowTex, v_mappedCoordRev);
    vec4 iconOutlineBottom = texture(uIconOutlineTex, v_mappedCoordRev);
    finalColor = vec4(mix(finalColor.rgb, iconShadow.rgb, iconShadow.a * uShowIconEffect), finalColor.a);
    finalColor = mix(finalColor, iconOutlineBottom, iconOutlineBottom.a * uShowIconEffect);

    float borderSdf = abs(dist) - uBgBorderWidth;
    float borderAlpha = (1.0 - smoothstep(-0.001, 0.001, borderSdf)) * shape * uShowBorder;
    fragColor = mix(finalColor, uBgBorderColor, borderAlpha);
}
