#version 300 es

in vec4 aPosition;
in vec2 aTextureCoord;

uniform float uAspectRatio;
uniform vec4 uRectBounds;
uniform float uRectExpand;
uniform float uRectRadius;

out vec2 v_originTexCoord;
out vec2 v_fragCoord;
out vec2 v_bgMappedCoord;
out vec2 v_mappedCoord;
out vec2 v_ibgMappedCoord;
out vec2 v_mappedCoordRev;
out vec2 v_rectCenter;
out vec2 v_rectSize;
out float v_rectRadius;

void main() {
    gl_Position = aPosition;
    v_originTexCoord = vec2(aTextureCoord.x, 1.0 - aTextureCoord.y);

    v_fragCoord = vec2(v_originTexCoord.x, v_originTexCoord.y / uAspectRatio);

    //  矩形计算
    vec4 expandedBounds = vec4(
    uRectBounds.x - uRectExpand,
    uRectBounds.y + uRectExpand,
    uRectBounds.z + uRectExpand,
    uRectBounds.w - uRectExpand
    );
    v_bgMappedCoord = vec2(
    (v_fragCoord.x - expandedBounds.x) / (expandedBounds.y - expandedBounds.x),
    (v_fragCoord.y - expandedBounds.w) / (expandedBounds.z - expandedBounds.w)
    );

    float uIRectExpand = uRectExpand + 0.01;
    //  矩形计算
    vec4 iExpandedBounds = vec4(
    uRectBounds.x - uIRectExpand,
    uRectBounds.y + uIRectExpand,
    uRectBounds.z + uIRectExpand,
    uRectBounds.w - uIRectExpand
    );
    v_ibgMappedCoord = vec2(
    (v_fragCoord.x - iExpandedBounds.x) / (iExpandedBounds.y - iExpandedBounds.x),
    (v_fragCoord.y - iExpandedBounds.w) / (iExpandedBounds.z - iExpandedBounds.w)
    );

    v_mappedCoord = vec2(
    (v_fragCoord.x - uRectBounds.x) / (uRectBounds.y - uRectBounds.x),
    (v_fragCoord.y - uRectBounds.w) / (uRectBounds.z - uRectBounds.w)
    );
    v_mappedCoordRev = vec2(v_mappedCoord.x, 1.0 - v_mappedCoord.y);
    v_rectCenter = (vec2(uRectBounds.x + uRectBounds.y, uRectBounds.w + uRectBounds.z)) * 0.5;
    v_rectSize = vec2(uRectBounds.y - uRectBounds.x, uRectBounds.z - uRectBounds.w) * 0.5;
    v_rectRadius = max(uRectRadius, 0.001);
}