#version 300 es

precision highp float;

in vec2 v_originTexCoord;
out vec4 fragColor;

uniform sampler2D uMainTex;
uniform float uCornerRadius;// 归一化半径 (0.0-1.0)
uniform float uAspectRatio;

float roundedRectSDF(vec2 position, vec2 center, vec2 size, float radius) {
    vec2 q = abs(position - center) - size + radius;
    return length(max(q, 0.0)) + min(max(q.x, q.y), 0.0) - radius;
}

void main() {
    // 将纹理坐标转换到中心点为原点的坐标系统
    vec2 centered = v_originTexCoord * 2.0 - 1.0;
    vec2 size = vec2(1.0);
    centered.y /= uAspectRatio;
    size.y /= uAspectRatio;

    // 计算到圆角矩形边缘的距离
    float dist = roundedRectSDF(centered, vec2(0.0), size, uCornerRadius);

    // 使用平滑过渡创建圆角遮罩
    float mask = smoothstep(0.001, 0.0, dist);

    // 获取原始纹理颜色
    vec4 texColor = texture(uMainTex, v_originTexCoord);

    // 在圆角外部使用红色，内部使用原始纹理
    vec4 finalColor = mix(vec4(1.0, 0.0, 0.0, 1.0), texColor, mask);

    fragColor = finalColor;
}