#version 300 es

precision highp float;

in vec2 v_originTexCoord;

uniform float offsetX;
uniform float offsetY;

uniform sampler2D uMainTex;
uniform vec3 uColor;

out vec4 fragColor;

void main() {
    // 计算基于像素的偏移量
    vec2 pixelOffset = vec2(offsetX, offsetY);

    float a = step(0.5, texture(uMainTex, vec2(v_originTexCoord.x, (1.0-v_originTexCoord.y)) - pixelOffset).a);
    fragColor = vec4(uColor, a);
}