#version 300 es
precision highp float;

in vec2 v_originTexCoord;

uniform sampler2D uIcon;
uniform sampler2D uShadow;
uniform sampler2D uBorder;

out vec4 fragColor;

void main() {

    // 获取各层的颜色
    vec4 shadowColor = texture(uShadow, v_originTexCoord);
    vec4 borderColor = texture(uBorder, v_originTexCoord);
    vec4 iconColor = texture(uIcon, v_originTexCoord);

    vec4 result = vec4(0.62, 0.68, 0.60, 1.0);
    result = mix(result, shadowColor, shadowColor.a);
    result = mix(result, borderColor, step(1.0, borderColor.a));
    result = mix(result, iconColor, step(1.0, iconColor.a));

    fragColor = result;
}