#version 300 es
precision highp float;

uniform sampler2D uPassTex;
uniform float uFrost;

in vec2 vUV;
out vec4 fragColor;

float ring_dist(vec2 uv, float radius) {
    return abs(length(uv) - radius);
}

vec2 hash22(vec2 uv) {
    vec3 p3 = fract(vec3(uv.xyx) * vec3(.1031, .1030, .0973));
    p3 += dot(p3, p3.yzx + 33.33);
    return fract((p3.xx + p3.yz) * p3.zy);
}

void main() {
    // Check if within rectangle bounds
    vec2 uv = vUV;
    vec2 noise = (hash22(uv * 1000.) * 2. - 1.)*(0.1*uFrost);
    vec2 uvTmp = clamp(uv + noise, 0.001, 0.999);
    vec3 color = pow(texture(uPassTex, uvTmp).rgb, vec3(2.2));
    vec3 srgb = pow(color, vec3(1. / 2.2));
    fragColor = vec4(srgb, 1.0);
}