#version 300 es
precision highp float;

uniform sampler2D uPassTex;
uniform float uAspectRatio;
uniform float uSquares;

#define DISTORT 0.05
#define PI 3.14159

in vec2 vUV;
in vec2 vRotated;
in vec2 vCentered;
in vec2 vRotDir;
out vec4 fragColor;

void main() {
    // 使用预计算的旋转结果
    float fract_x = fract(vRotated.x / uSquares);
    vec2 distortedUV = vCentered + vRotDir * sin(fract_x * PI * 2.0) * DISTORT;

    // 边界限制和UV转换
    distortedUV = clamp(distortedUV, vec2(-0.17, -1.0), vec2(0.2251, 1.0));
    vec2 finalUV = clamp(distortedUV / vec2(uAspectRatio, 1.0) + 0.5, 0.001, 0.999);

    // 采样和混合
    fragColor = texture(uPassTex, finalUV) + vec4(abs(fract_x) * 0.1);
    // fragColor = texture(passTex, vUV);
}