#version 300 es

in vec4 aPosition;
in vec2 aTextureCoord;

uniform float uAspectRatio;
uniform vec4 uRectBounds;
uniform float uScale;
uniform float uTime;
uniform vec2 uResolution;
uniform vec2 uMouse;

out vec2 vUV;
out vec2 vFragCoord;

void main() {
    vec2 uv = vec2(aTextureCoord.x, 1.0-aTextureCoord.y);
    gl_Position = aPosition;
    vUV = uv;
    // 修正坐标计算
    vFragCoord = (uv * 2.0 - 1.0) * vec2(uResolution.x / uResolution.y, 1.0) * 100.0;
}