#version 300 es

in vec4 aPosition;
in vec2 aTextureCoord;

uniform float uAspectRatio;
uniform vec4 uRectBounds;

out vec2 vUV;

void main() {
    vec2 uv = vec2(aTextureCoord.x, 1.0-aTextureCoord.y);
    vec2 fragCoord = vec2(uv.x, uv.y/uAspectRatio);

    // 计算映射到矩形区域的 UV 坐标
    vec2 mappedUV = vec2(
    (fragCoord.x - uRectBounds.x) / (uRectBounds.y - uRectBounds.x),
    (fragCoord.y - uRectBounds.w) / (uRectBounds.z - uRectBounds.w)
    );

    gl_Position = aPosition;
    vUV = vec2(mappedUV.x, 1.0 - mappedUV.y);  // 使用映射后的 UV 坐标
}