#version 300 es
precision highp float;

uniform sampler2D uMainTex;
uniform float uTime;

in vec2 vUV;
in vec4 vRectBounds;
in vec2 vFragCoord;

out vec4 fragColor;

// 波浪效果函数
vec2 waveOffset(vec2 p, float time) {
    float angle = time * 2.0;
    float wave1 = sin(p.x * 4.0 + time) * 0.02;
    float wave2 = cos(p.y * 3.0 + time * 0.8) * 0.02;
    return vec2(wave1, wave2);
}

void main() {
    vec2 rectCenter = vec2(
        (vRectBounds.x + vRectBounds.y) * 0.5,
        (vRectBounds.w + vRectBounds.z) * 0.5
    );
    
    vec2 rectSize = vec2(
        (vRectBounds.y - vRectBounds.x) * 0.5,
        (vRectBounds.z - vRectBounds.w) * 0.5
    );
    
    vec2 p = vFragCoord - rectCenter;
    vec2 normalizedP = p / rectSize;
    float distToCenter = length(normalizedP);
    
    if(vFragCoord.x >= vRectBounds.x && vFragCoord.x <= vRectBounds.y && 
       vFragCoord.y >= vRectBounds.w && vFragCoord.y <= vRectBounds.z) {
        
        float maxMagnification = 2.5;
        float minMagnification = 1.2;
        float magnification = mix(maxMagnification, minMagnification, 
                                smoothstep(0.0, 1.0, distToCenter));
        
        // 添加波浪扭曲效果
        vec2 wave = waveOffset(normalizedP, uTime);
        vec2 magnifiedUV = vUV + (p + wave * rectSize)/(magnification * rectSize);
        
        vec4 magnifiedColor = texture(uMainTex, magnifiedUV);
        vec4 originalColor = texture(uMainTex, vUV);
        
        // 添加波浪边缘效果
        float edgeWidth = 0.15;
        float waveEdge = sin(atan(normalizedP.y, normalizedP.x) * 8.0 + uTime * 3.0) * 0.05;
        float t = smoothstep(1.0 - edgeWidth, 1.0 + waveEdge, distToCenter);
        
        // 添加发光效果
        vec3 glowColor = vec3(0.4, 0.6, 1.0);
        float glow = (1.0 - t) * 0.2;
        
        fragColor = mix(magnifiedColor, originalColor, t);
        fragColor.rgb += glowColor * glow;
        
    } else {
        fragColor = vec4(0.0);
    }
}