#version 300 es

in vec4 aPosition;
in vec2 aTextureCoord;

uniform float uAspectRatio;
uniform vec4 uRectBounds;

out vec2 vUV;
out vec4 vRectBounds;
out vec2 vFragCoord;

const float EXTEND = 0.08;

void main() {
    vec2 uv = vec2(aTextureCoord.x, 1.0-aTextureCoord.y);
    
    vRectBounds = vec4(
        uRectBounds.x - EXTEND,
        uRectBounds.y + EXTEND,
        uRectBounds.z + EXTEND,
        uRectBounds.w - EXTEND
    );
    
    vFragCoord = vec2(uv.x, uv.y/uAspectRatio);
    gl_Position = aPosition;
    vUV = uv;
}