#version 300 es

in vec4 aPosition;
in vec2 aOffset;// Box2D世界坐标
in vec2 aTextureCoord;

uniform float uAspectRatio;
uniform vec2 uWorldSize;// x:物理世界宽度, y:物理世界高度
uniform float uParticleSize;// 粒子大小（已归一化到[-1,1]范围）

out vec2 v_originTexCoord;
out vec2 v_fragCoord;

void main() {
    // 将Box2D世界坐标转换为OpenGL坐标 [-1, 1]
    vec2 glOffset = aOffset / (uWorldSize * 0.5);
    
    // 应用粒子大小
    vec2 scaledPosition = aPosition.xy * uParticleSize;
    
    // 使用转换后的OpenGL坐标，并保持纵横比
    vec2 pos = vec2(scaledPosition.x, scaledPosition.y * uAspectRatio) + vec2(glOffset.x, glOffset.y);

    gl_Position = vec4(pos, aPosition.zw);
    v_originTexCoord = aTextureCoord;
}