#version 300 es

precision mediump float;

in vec2 v_originTexCoord;

uniform sampler2D uPassTex;
uniform float rate;

uniform float blackBorderIntensity;
uniform float blackBorderExtend;

out vec4 fragColor;

void main() {

    // 计算渐变强度
    vec2 uv = v_originTexCoord;
    uv *= 1.0 - uv.yx;// 反转 y 和 x 以生成渐变
    float vig = uv.x * uv.y * blackBorderIntensity;
    vig = pow(vig, blackBorderExtend);

    fragColor = texture(uPassTex, v_originTexCoord) * mix(vig, 1.0, rate) ;
}
