#version 300 es
precision highp float;

uniform sampler2D uPassTex;
uniform sampler2D uBlurTex;
uniform float uRate;

in vec2 vUV;
out vec4 fragColor;

float ring_dist(vec2 uv, float radius) {
    return abs(length(uv) - radius);
}

vec2 hash22(vec2 uv) {
    vec3 p3 = fract(vec3(uv.xyx) * vec3(.1031, .1030, .0973));
    p3 += dot(p3, p3.yzx + 33.33);
    return fract((p3.xx + p3.yz) * p3.zy);
}

void main() {
    vec2 uv = vUV;

    // (-1,1)*(0-0.1)
    vec2 noise = (hash22(uv * 1000.) * 2. - 1.)*(0.1*uRate);
    //  0.01, 0.99 解决边缘模糊问题
    vec2 uvTmp = clamp(uv + noise, 0.001, 0.999);
    vec3 color = pow(mix(texture(uPassTex, uvTmp).rgb,
    texture(uBlurTex, vec2(uvTmp.x, 1.0 - uvTmp.y)).rgb, uRate), vec3(2.2));

    vec3 srgb = pow(color, vec3(1. / 2.2));

    fragColor =vec4(srgb, 1.0);
}