#version 300 es
precision highp float;

in vec2 v_originTexCoord;
out vec4 fragColor;

uniform float uAngle;
uniform float uAspectRatio;
uniform vec3 uStartColor;
uniform vec3 uEndColor;
uniform float uCenterY;     // 渐变中心Y轴偏移

float antiAlias(vec2 p) {
    vec2 px = dFdx(p);
    vec2 py = dFdy(p);
    float fx = length(px) * 0.5;
    float fy = length(py) * 0.5;
    
    const int SAMPLES = 20;
    float sum = 0.0;
    
    for(int i = 0; i < SAMPLES; i++) {
        for(int j = 0; j < SAMPLES; j++) {
            vec2 offset = vec2(float(i), float(j)) / float(SAMPLES) - 0.5;
            vec2 pos = p + offset.x * px + offset.y * py;
            sum += atan(pos.y, pos.x);
        }
    }
    
    return sum / float(SAMPLES * SAMPLES);
}

void main() {
    vec2 v = v_originTexCoord * 2.0 - 1.0;
    v.x *= uAspectRatio;
    
    // 修改Y轴偏移的映射方式
    v.y += (0.5 - uCenterY) * 2.0;  // 将0.5作为中心点参考
    
    vec2 rotated = vec2(
        v.x * cos(uAngle) - v.y * sin(uAngle),
        v.x * sin(uAngle) + v.y * cos(uAngle)
    );
    
    float t = 0.1 + antiAlias(rotated)/3.14159;
    fragColor = vec4(mix(uStartColor.rgb, uEndColor.rgb, t), 1.0);
}