#version 300 es
precision highp float;

uniform sampler2D uMainTex;
uniform vec4 uEdgeFlags;
uniform float uBorderWidth;
uniform vec2 uResolution;
uniform vec3 uBorderColor;  // 添加边框颜色uniform

in vec2 v_originTexCoord;
out vec4 fragColor;

void main() {
    // 将边框宽度转换为纹理坐标空间
    vec2 pixelSize = 1.0 / uResolution;
    float borderWidthW = uBorderWidth * pixelSize.x;  // 使用像素宽度
    float borderWidthH = uBorderWidth * pixelSize.y;  // 使用像素宽度

    // 计算到边缘的距离
    float distanceToLeft = v_originTexCoord.x;
    float distanceToRight = 1.0 - v_originTexCoord.x;
    float distanceToTop = 1.0 - v_originTexCoord.y;
    float distanceToBottom = v_originTexCoord.y;

    // 分别判断每个边是否需要绘制
    bool drawLeft = distanceToLeft < borderWidthW && uEdgeFlags.x < 0.5;
    bool drawRight = distanceToRight < borderWidthW && uEdgeFlags.z < 0.5;
    bool drawTop = distanceToTop < borderWidthH && uEdgeFlags.y < 0.5;
    bool drawBottom = distanceToBottom < borderWidthH && uEdgeFlags.w < 0.5;

    if (drawLeft || drawRight || drawTop || drawBottom) {
        fragColor = vec4(uBorderColor, 1.0);  // 使用边框颜色
    } else {
        fragColor = texture(uMainTex, v_originTexCoord);
    }
}