#version 300 es
precision highp float;

vec3 srgbToLinear(vec3 c) {
    return pow(c, vec3(2.2));
}

vec3 linearToSrgb(vec3 c) {
    return pow(c, vec3(1.0 / 2.2));
}

vec3 srgb(float r, float g, float b) {
    return srgbToLinear(vec3(r, g, b) / 255.0);
}

uniform vec3 color1;      // 渐变色1
uniform vec3 color2;      // 渐变色2
uniform vec2 touchEndPos;    // 当前触摸位置
uniform vec2 touchBeginPos;   // 触摸开始位置

in vec2 v_originTexCoord;
out vec4 fragColor;

float triangularNoise(vec2 coord) {
    vec2 seed = coord;
    float n1 = fract(52.9829189 * fract(dot(seed, vec2(0.06711056, 0.00583715))));
    float n2 = fract(52.9829189 * fract(dot(seed, vec2(0.07568156, 0.01623715))));
    return (n1 + n2) * 0.5;
}

const mat4 bayerMatrix = mat4(
    0.0/16.0, 8.0/16.0, 2.0/16.0, 10.0/16.0,
    12.0/16.0, 4.0/16.0, 14.0/16.0, 6.0/16.0,
    3.0/16.0, 11.0/16.0, 1.0/16.0, 9.0/16.0,
    15.0/16.0, 7.0/16.0, 13.0/16.0, 5.0/16.0
);

float getDither(vec2 coord) {
    vec2 screenPos = coord * 2000.0;
    ivec2 matrixPos = ivec2(int(screenPos.x) % 4, int(screenPos.y) % 4);
    float bayer = bayerMatrix[matrixPos.x][matrixPos.y];
    float noise = triangularNoise(coord * 2000.0);
    return mix(bayer, noise, 0.5);
}

void main() {
    vec2 ba = touchEndPos - touchBeginPos;
    float t = dot(v_originTexCoord - touchBeginPos, ba) / dot(ba, ba);
    t = smoothstep(0.0, 1.0, clamp(t, 0.0, 1.0));
    
    vec3 c1 = srgbToLinear(color1);
    vec3 c2 = srgbToLinear(color2);
    vec3 color = mix(c1, c2, t);
    color = linearToSrgb(color);
    
    // 混合 Bayer 矩阵和 Triangular Noise
    float dither = getDither(v_originTexCoord);
    color += (4.0/255.0) * dither - (2.0/255.0);
    
    fragColor = vec4(color, 1.0);
}