#version 300 es

in vec4 aPosition;
in vec2 aTextureCoord;

uniform float uAngle;
uniform float uAspectRatio;

out vec2 vUV;
out vec2 vRotated;
out vec2 vCentered;
out vec2 vRotDir;  // 添加旋转方向向量的输出

void main() {
    gl_Position = aPosition;
    vUV = aTextureCoord;
    
    // 计算中心对齐的坐标
    vCentered = (aTextureCoord - 0.5) * vec2(uAspectRatio, 1.0);

    // 预计算旋转
    float c = cos(uAngle);
    float s = sin(uAngle);
    vRotated = mat2(c, -s, s, c) * vCentered;
    
    // 预计算旋转方向向量
    vRotDir = vec2(c, s);
}