#version 300 es

precision mediump float;

in vec2 vUV;

uniform sampler2D uPassTex;
uniform float uRate;

uniform float blackBorderIntensity;
uniform float blackBorderExtend;

out vec4 fragColor;

void main() {

    // 计算渐变强度
    vec2 uv = vUV;
    uv *= 1.0 - uv.yx;// 反转 y 和 x 以生成渐变
    float vig = uv.x * uv.y * blackBorderIntensity;
    vig = pow(vig, blackBorderExtend);

    fragColor = texture(uPassTex, vUV) * mix(vig, 1.0, uRate);
}
