#version 300 es

precision mediump float;

uniform sampler2D uPassTex;
uniform sampler2D uBlurTex;
uniform vec3 u_translation;
uniform float u_lens_scale;
uniform float u_aspect_ratio;
uniform float u_edge_smoothness;
uniform int u_show_blur_bg;

in vec2 v_originTexCoord;
in vec2 v_circleTexCoord;

out vec4 fragColor;

uniform vec3 strokeColor;
uniform vec3 bgColor;

void main()
{
    vec2 uv = v_originTexCoord;
    vec2 uvCenter = vec2(0.5 + u_translation.x, (0.5 + u_translation.y) * u_aspect_ratio);
    float dist = distance(vec2(uv.x, uv.y * u_aspect_ratio), uvCenter);

    // 计算边缘过渡
    float smoothFactor = smoothstep(u_lens_scale - u_edge_smoothness, u_lens_scale, dist);
    
    // 计算描边 - 更清晰的版本
    float strokeWidth = 0.008; // 减小描边宽度
    float innerStroke = smoothstep(u_lens_scale - strokeWidth, u_lens_scale - strokeWidth * 0.5, dist);
    float outerStroke = 1.0 - smoothstep(u_lens_scale, u_lens_scale + strokeWidth * 0.5, dist);
    float strokeFactor = innerStroke * outerStroke;

    // 纹理颜色
    vec4 texColor = texture(uPassTex, uv);

    vec4 color;
    if (u_show_blur_bg == 1) {
        color = mix(texColor, texture(uBlurTex, uv), smoothFactor);
    } else {
        color = mix(texColor, vec4(bgColor, 1.0), smoothFactor);
    }
    
    // 添加描边
    color = mix(color, vec4(strokeColor, 1.0), strokeFactor);
    
    fragColor = color;
}
