#version 300 es

precision mediump float;
in vec4 aPosition;
in vec2 aTextureCoord;
uniform vec4 u_circleUvTras;
uniform float u_lens_scale;
uniform float u_lens_y_offset;
uniform float u_aspect_ratio;

out vec2 v_originTexCoord;
out vec2 v_circleTexCoord;

vec2 scaleUV(vec2 uv, float scaleX, float scaleY) {
    // Step 1: 将 UV 移动到中心 (0.5, 0.5)
    uv -= 0.5;

    // Step 2: 对 UV 进行缩放 (注意 scale > 1.0 时图像变大)
    uv.x /= scaleX;  // 使用除法来实现放大效果
    uv.y /= scaleY;  // 使用除法来实现放大效果

    // Step 3: 将 UV 移回原始坐标系
    uv += 0.5;
    uv.y += u_lens_y_offset;

    return uv;
}

void main() {
    gl_Position = aPosition;
    v_originTexCoord = aTextureCoord;
    v_circleTexCoord = scaleUV(aTextureCoord,
    u_aspect_ratio*(u_lens_scale*1.2), 1.0*(u_lens_scale)*1.2);
}