#version 300 es
precision highp float;

in vec2 v_originTexCoord;
in vec2 v_decorato_texCoord;

uniform sampler2D uPassTex;
uniform sampler2D uBlurTex;
uniform sampler2D uMainTex2;

uniform vec3 u_translation;
uniform mat4 u_texture_matrix;
uniform float u_lens_scale;
uniform float u_aspect_ratio;
uniform float u_aspect_ratio_r;
uniform float u_distortion;
uniform float u_zoom;
uniform float da;
uniform float s;
uniform float ds;
uniform float uRate;

out vec4 fragColor;

// 常量定义
const vec3 LUMINANCE_WEIGHTS = vec3(0.2125, 0.7154, 0.0721);
const float LENS_EDGE_SMOOTH = 0.002;
const float COLOR_ADJUST = 0.3;
const float CONTRAST_ADJUST = 0.1;
const float RED_BLUE_ADJUST = 0.063;
const float SATURATION_ADJUST = 0.18;

// 颜色调整函数
vec4 adjustColor(vec4 color, float strength) {
    if (strength <= 0.01) return color;
    
    // 降低亮度
    color.rgb *= (1.0 - COLOR_ADJUST * strength);
    
    // 调整对比度
    color.rgb = (color.rgb - 0.5) * (1.0 - CONTRAST_ADJUST * strength) + 0.5;
    
    // 调整红蓝通道
    color.rb = vec2(
        color.r * (1.0 - RED_BLUE_ADJUST * strength),
        color.b * (1.0 + RED_BLUE_ADJUST * strength)
    );
    
    // 调整饱和度
    float luminance = dot(color.rgb, LUMINANCE_WEIGHTS);
    color.rgb = mix(vec3(luminance), color.rgb, (1.0 - SATURATION_ADJUST * strength));
    
    return color;
}

// 颜色混合函数
vec3 blendColors(vec3 baseColor, vec3 blendColor, float opacity) {
    return blendColor * opacity + baseColor * (1.0 - opacity);
}

// 径向畸变函数
vec2 applyRadialDistortion(vec2 coord, float distortion) {
    return coord * (1.0 - distortion * dot(coord, coord));
}

// 缩放函数
vec2 applyZoom(vec2 coord, vec2 center, float zoom) {
    return (coord - center) * zoom + center;
}

// 应用饱和度调整
vec3 adjustSaturation(vec3 color, float saturation) {
    return mix(vec3(dot(color, LUMINANCE_WEIGHTS)), color, 1.0 + saturation);
}

void main() {
    // 计算中心点
    vec2 center = vec2(0.5 + u_translation.x, (0.5 + u_translation.y) * u_aspect_ratio);
    vec2 pixelCoord = v_originTexCoord;
    
    // 检查是否在镜头范围内
    float distanceToCenter = distance(pixelCoord, center);
    if (distanceToCenter > u_lens_scale) {
        fragColor = vec4(0.0, 0.0, 0.0, 1.0);
        return;
    }
    
    // 应用畸变和缩放
    vec2 distortedCoord = applyZoom(
        pixelCoord + applyRadialDistortion(pixelCoord - center, u_distortion),
        center,
        u_zoom
    );
    
    // 应用纹理矩阵变换
    vec2 textureCoord = (u_texture_matrix * vec4(
        (vec2(distortedCoord.x, distortedCoord.y * u_aspect_ratio_r) * 2.0) - 1.0,
        0.0,
        1.0
    )).xy;
    
    // 混合原始和模糊纹理
    vec3 baseColor = mix(
        texture(uPassTex, textureCoord).rgb,
        texture(uBlurTex, textureCoord).rgb,
        uRate
    );
    
    // 应用装饰效果
    if (da > 0.0001) {
        baseColor = adjustSaturation(baseColor, da * s);
        vec4 decorColor = texture(uMainTex2, v_decorato_texCoord);
        baseColor = blendColors(baseColor, decorColor.rgb, decorColor.a * da);
    }
    
    // 应用最终颜色调整
    vec4 finalColor = adjustColor(vec4(baseColor, 1.0), ds);
    
    // 应用边缘渐变
    float edgeFade = smoothstep(u_lens_scale - LENS_EDGE_SMOOTH, u_lens_scale, distanceToCenter);
    fragColor = (1.0 + ds) * mix(finalColor, vec4(0.0), edgeFade);
}