#version 300 es

in vec4 aPosition;
in vec2 aTextureCoord;

out vec2 vCircleUV;

uniform mat4 u_decorator_matrix;
uniform float u_aspect_ratio;

out vec2 v_originTexCoord;
out vec2 v_decorato_texCoord;

void main() {
    gl_Position = aPosition;

    v_originTexCoord = vec2(aTextureCoord.x, aTextureCoord.y * u_aspect_ratio);
    v_decorato_texCoord = (u_decorator_matrix * vec4((aTextureCoord * 2.0) - 1.0, 0.0, 1.0)).xy;
    v_decorato_texCoord.y = 1.0 - v_decorato_texCoord.y;
}