#version 300 es
precision highp float;

uniform sampler2D uMainTex;
uniform float uFrostStrength;  // 添加霜化强度参数 0.0-1.0

in vec2 v_originTexCoord;
out vec4 fragColor;

float ringDist(vec2 uv, float radius) {
    return abs(length(uv) - radius);
}

vec2 hash22(vec2 uv) {
    vec3 p3 = fract(vec3(uv.xyx) * vec3(.1031, .1030, .0973));
    p3 += dot(p3, p3.yzx + 33.33);
    return fract((p3.xx + p3.yz) * p3.zy);
}

void main() {
    vec2 uv = v_originTexCoord;

    // 使用强度参数控制噪声影响
    vec2 noise = (hash22(uv * 1000.) * 2. - 1.) * (0.1 * uFrostStrength);
    vec2 uvTmp = clamp(uv + noise, 0.001, 0.999);
    vec3 color = pow(texture(uMainTex, uvTmp).rgb, vec3(2.2));

    // 当强度为0时，直接使用原始UV采样
    if (uFrostStrength <= 0.0) {
        color = pow(texture(uMainTex, uv).rgb, vec3(2.2));
    }

    vec3 srgb = pow(color, vec3(1. / 2.2));
    fragColor = vec4(srgb, 1.0);
}