#version 300 es
precision highp float;

uniform sampler2D uMainTex;
uniform vec2 uResolution;
uniform float uSquares;

#define DISTORT 0.05
#define PI 3.14159

in vec2 v_originTexCoord;
in vec2 vRotated;
in vec2 vCentered;
in vec2 vRotDir;
out vec4 fragColor;

void main() {
    if (uSquares <= 0.0) {
        fragColor = texture(uMainTex, v_originTexCoord);
        return;
    }

    // 使用预计算的旋转结果
    float fract_x = fract(vRotated.x / uSquares);
    vec2 distortedUV = vCentered + vRotDir * sin(fract_x * PI * 2.0) * DISTORT;

    // 边界限制
    distortedUV = clamp(distortedUV, vec2(-0.17, -1.0), vec2(0.2251, 1.0));

    // 转换回UV空间
    vec2 uv = distortedUV / vec2(uResolution.x/uResolution.y, 1.0) + 0.5;
    // 确保UV在有效范围内
    uv = clamp(uv, vec2(0.001), vec2(0.999));

    vec4 color = texture(uMainTex, uv);
    color.rgb += abs(fract_x) * 0.1; // 玻璃纹理效果

    fragColor = vec4(color.rgb, 1.0);
}