#version 300 es

precision mediump float;

in vec4 aPosition;
in vec2 aTextureCoord;

uniform float uUpsetDown;
uniform float uAngle;  // 添加角度参数
uniform float uAspectRatio;

out vec2 v_originTexCoord;
out vec2 vRotated;    // 预计算的旋转结果
out vec2 vCentered;   // 中心对齐的坐标
out vec2 vRotDir;     // 旋转方向向量

void main() {
    gl_Position = aPosition;
    v_originTexCoord = vec2(aTextureCoord.x, uUpsetDown > 1.0 ? 1.0 - aTextureCoord.y : aTextureCoord.y);
    
    // 计算中心对齐的坐标
    vCentered = (v_originTexCoord - 0.5) * vec2(uAspectRatio, 1.0);
    
    // 预计算旋转
    float c = cos(uAngle);
    float s = sin(uAngle);
    vRotated = mat2(c, -s, s, c) * vCentered;
    
    // 预计算旋转方向向量
    vRotDir = vec2(c, s);
}