#version 300 es
precision highp float;

uniform sampler2D uMainTex;

in vec2 v_originTexCoord;

uniform float blackBorderIntensity;
uniform float blackBorderExtend;

out vec4 fragColor;

void main() {
    // 当 blackBorderIntensity 为 0 时直接显示原图
    if (blackBorderIntensity <= 0.0 && blackBorderExtend <= 0.0) {
        fragColor = texture(uMainTex, v_originTexCoord);
        return;
    }

    // 计算渐变强度
    vec2 uv = v_originTexCoord;
    uv *= 1.0 - uv.yx;
    float vig = uv.x * uv.y * blackBorderIntensity;
    vig = pow(vig, blackBorderExtend);

    fragColor = vec4(texture(uMainTex, v_originTexCoord).rgb * vig, 1.0);
}