#version 300 es

precision mediump float;

in vec4 aPosition;
in vec2 aTextureCoord;

uniform float uImageAspect;
uniform float uScreenAspect;

out vec2 vUV;

void main() {
    gl_Position = aPosition;

    // 计算UV缩放
    vec2 uv = aTextureCoord;
    if (uImageAspect > uScreenAspect) {
        // 图片比屏幕宽，需要在垂直方向拉伸UV
        float scale = uImageAspect / uScreenAspect;
        float offset = (1.0 - scale) * 0.5;
        uv.y = uv.y * scale + offset;
    } else {
        // 图片比屏幕高，需要在水平方向拉伸UV
        float scale = uScreenAspect / uImageAspect;
        float offset = (1.0 - scale) * 0.5;
        uv.x = uv.x * scale + offset;
    }

    vUV = uv;
}