#version 300 es

precision highp float;

in vec2 vUV;

uniform sampler2D uMainTex;
uniform vec4 uTexSize;// (w, h, 1/w, 1/h)
uniform float uSampleOffset;
uniform float uScreenRate;

out vec4 fragColor;

/*

vec2 rand( vec2  p ) { p = vec2( dot(p,vec2(127.1,311.7)), dot(p,vec2(269.5,183.3)) ); return fract(sin(p)*43758.5453); }
// blur2
void main()
{

    fragColor = texture( uMainTex, vUV + uSampleOffset*(rand(vUV)-0.5));
}*/


// blur1
/*
void main()
{
    float lod = (5.0 + 5.0*sin(uSampleOffset));

    vec3 col = texture( uMainTex, vec2(vUV.x,vUV.y), lod ).xyz;

    fragColor = vec4( col, 1.0 );
}*/

// blur3

// Can go down to 10 or so, and still be usable, probably...
#define ITERATIONS 30
#define TAU  6.28318530718
#define HASHSCALE 443.8975

// Use last part of hash function to generate new random radius and angle...
vec2 Sample(inout vec2 r)
{
    r = fract(r * vec2(33.3983, 43.4427));
    return r-.5;
    //return sqrt(r.x+.001) * vec2(sin(r.y * TAU), cos(r.y * TAU))*.5; // <<=== circular sampling.
}

vec2 Hash22(vec2 p)
{
    vec3 p3 = fract(vec3(p.xyx) * HASHSCALE);
    p3 += dot(p3, p3.yzx+19.19);
    return fract(vec2((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y));
}

vec3 Blur(vec2 uv, float radius)
{
    radius = radius * .04;

    vec2 circle = vec2(radius) * vec2((uScreenRate), 1.0);

    // Remove the time reference to prevent random jittering if you don't like it.
    vec2 random = Hash22(uv);

    // Do the blur here...
    vec3 acc = vec3(0.0);
    for (int i = 0; i < ITERATIONS; i++)
    {
        acc += texture(uMainTex, uv + circle * Sample(random), radius*10.0).xyz;
    }
    return acc / float(ITERATIONS);
}

void main()
{
    fragColor = vec4(Blur(vUV * vec2(1.0, 1.0), uSampleOffset), 1.0);
}