#version 300 es
precision highp float;

uniform float uTime;

in vec4 aPosition;
in vec2 aTextureCoord;

out vec2 vUV;
out float vFlashOffset;

void main()
{
    gl_Position = aPosition;
    vUV = aTextureCoord;
    vFlashOffset = exp(mod(uTime - 1.0, 6.0) * -5.0) * (sin(uTime * 36.0) * 0.2 + 0.2);
}