#version 300 es

precision mediump float;

in vec2 v_originTexCoord;

uniform sampler2D currentTex;
uniform sampler2D nextTex;
uniform int nightEyeProtection;

uniform float rate;

out vec4 fragColor;

void main() {
    // 计算两张图片的纹理坐标
    // 第一张图片随着滑动从右向左移出，第二张图片从左向右滑入
    vec2 texCoord1 = vec2(mod(v_originTexCoord.x + rate, 1.0), v_originTexCoord.y);
    vec2 texCoord2 = vec2(mod(v_originTexCoord.x + rate - 1.0, 1.0), v_originTexCoord.y);
    vec4 color;
    // 判断当前像素是在哪个页面（滑动范围中）
    if (v_originTexCoord.x + rate < 1.0) {
        // 在第一页区域，显示第一张图片
        color = texture(currentTex, texCoord1);
    } else {
        // 在第二页区域，显示第二张图片
        color = texture(nextTex, texCoord2);
    }

    if (nightEyeProtection == 0){
        fragColor = color;
    } else if (nightEyeProtection == 1){
        fragColor = color*vec4(255.0/255., 237.0/255.0, 182.0/255.0, 1.0);
    } else {
        float gray = dot(color.rgb, vec3(0.299, 0.587, 0.114));
        fragColor = vec4(vec3(gray) * 0.9, color.a);
    }
}
