#version 300 es

precision mediump float;

// Input varyings
in vec2 v_originTexCoord;
in vec2 v_lockOriginTexCoord;
in vec2 v_originTexCoord_local;
in vec3 vONormal;
in float vRandom;
in float isEdge;

// Uniforms
uniform sampler2D uCellDecTex;
uniform sampler2D uCellTex;
uniform sampler2D uCellEdgeTex;
uniform sampler2D uCurrentMainTex;
uniform sampler2D uNextMainTex;
uniform sampler2D uLockTex;
uniform int nightEyeProtection;
uniform float u_aspect_ratio;
uniform float uRate;
uniform float uProgress;
uniform vec3 uInnerCellPos;
uniform vec3 uCellPlaneColor;
uniform int uSkinType;

// Constants
const float shadowWidth = 0.9;
const float shadowIntensity = 33.7;
const float lockShadowIntensity = 0.01;

// Output
out vec4 fragColor;

// SDF for rectangle
float rectSDF(vec2 p, vec2 size) {
    vec2 d = abs(p) - size;
    return length(max(d, 0.0)) + min(max(d.x, d.y), 0.0);
}

void main() {
    vec4 currentColor;
    vec4 nextColor;

    // Calculate face based on normal
    vec3 absNormal = abs(vONormal);
    float maxComp = max(max(absNormal.x, absNormal.y), absNormal.z);

    // Side faces handling
    if (maxComp == absNormal.x) {
        currentColor = vec4(uCellPlaneColor * 0.5, 1.0) * uRate;
    } else if (maxComp == absNormal.y) {
        currentColor = vec4(uCellPlaneColor * 0.3, 1.0) * uRate;
    } else if (vONormal.z > 0.5) {
        // Front face
        if (isEdge > 0.0) {
            currentColor = (uSkinType == 0) 
                ? mix(texture(uCurrentMainTex, v_originTexCoord), 
                     texture(uNextMainTex, v_originTexCoord), 
                     uProgress)
                : texture(uCellEdgeTex, v_originTexCoord);
        } else {
            vec4 cellDecTex = texture(uCellDecTex, v_originTexCoord_local);
            if (uSkinType == 0) {
                vec4 curr = texture(uCurrentMainTex, v_originTexCoord) * cellDecTex * vRandom;
                vec4 next = texture(uNextMainTex, v_originTexCoord) * cellDecTex * vRandom;
                currentColor = mix(curr, next, uProgress);
            } else {
                currentColor = texture(uCellTex, v_originTexCoord_local) * vRandom * cellDecTex;
            }
            currentColor *= 1.3;
        }
    } else {
        // Back face
        currentColor = texture(uLockTex, v_lockOriginTexCoord);
    }

    // Calculate inner shadow
    /*vec2 normalizedCoord = v_originTexCoord * 2.0 - 1.0;
    normalizedCoord.x *= u_aspect_ratio;
    normalizedCoord.y += uInnerCellPos.z;
    float rectDistance = rectSDF(normalizedCoord, vec2(uInnerCellPos.x, uInnerCellPos.y));

    if (rectDistance > -0.1 && rectDistance < 0.0) {
        // float z = zDeep + (1.0 - uRate) * lockShadowIntensity + (uCellStyle == 0 ? 0.0 : 0.01);
        float z = zDeep;
        float innerShadow = smoothstep(-shadowWidth * z, 0.0, rectDistance);
        currentColor.rgb *= (1.0 - innerShadow * shadowIntensity * z);
    }*/

    // Apply night eye protection
    if (nightEyeProtection == 1) {
        currentColor.r = min(currentColor.r, 0.7);
        currentColor.b *= 0.8;
    }

    fragColor = currentColor;
}
