#version 300 es

precision mediump float;

in vec2 v_originTexCoord;

uniform sampler2D currentTex;
uniform sampler2D nextTex;
uniform int nightEyeProtection;

uniform float rate;

out vec4 fragColor;

void main() {
    vec2 uv = v_originTexCoord;
    vec4 _currentTex;
    vec4 _nextTex;
    float intensity = 0.3;

    // 获取原始的纹理颜色
    vec4 orig1 = texture(currentTex, uv);
    vec4 orig2 = texture(nextTex, uv);

    // 使用亮度公式计算每个纹理的亮度
    float luminance1 = dot(orig1.rgb, vec3(0.299, 0.587, 0.114));// 计算 currentTex 的亮度
    float luminance2 = dot(orig2.rgb, vec3(0.299, 0.587, 0.114));// 计算 nextTex 的亮度

    // 使用亮度来修改纹理坐标
    _currentTex = texture(currentTex, vec2(uv.x + rate * luminance2 * intensity, uv.y));
    _nextTex = texture(nextTex, vec2(uv.x+ (1.0 - rate) * luminance1 * intensity, uv.y));

    // 根据 rate 混合两个纹理
    vec4 color = mix(_currentTex, _nextTex, rate);
    if (nightEyeProtection == 0){
        fragColor = color;
    } else if (nightEyeProtection == 1){
        fragColor = color*vec4(255.0/255., 237.0/255.0, 182.0/255.0, 1.0);
    } else {
        float gray = dot(color.rgb, vec3(0.299, 0.587, 0.114));
        fragColor = vec4(vec3(gray) * 0.9, color.a);
    }
}
