#version 300 es

precision highp float;

in vec4 aPosition;
in vec2 aTextureCoord;
uniform float u_aspect_ratio;
uniform float uRate;
uniform float uTime;
uniform vec2 uCircleOffset;
uniform float uRectCornerRadius;
uniform float uHighlightWidth;
uniform float uBgBlur;
uniform vec2 uRect2Size;
uniform vec2 uRectSize;

uniform vec2 uRectPos;
uniform vec2 uRect2Pos;

out vec2 v_originTexCoord;
out float rateRev;
out float rate2;
out float rate3;
out float xr;
out float radius;
out float bgRate;
out vec2 texCoord;
out vec2 pos;
out vec2 pos2;
out vec2 hr;
out vec2 vp1;
out vec2 vp2;
out vec2 rect2Size;
out vec2 rectSize;
out float rate02;
out float hlWidth;
out float circleRadius;
out float shadowSize;
out vec3 highlightColor;
out vec2 lightDir1;
out vec2 lightDir2;
out float shadowIntensity;// 优化: 阴影强度预计算
out vec2 distortSpeed;// 优化: 扰动速度预计算
out float distortFreq;// 优化: 扰动频率预计算
out float F0;// 优化: 菲涅尔基础反射率
out float specularPower;// 优化: 高光强度系数
out float highlightEdgeSmoothness;// 优化: 高光边缘平滑度
out float glassTransparency;// 优化: 玻璃透明度预计算
out float transitionWidth;// 优化: 过渡区域宽度预计算

void main() {
    gl_Position = aPosition;
    v_originTexCoord = vec2(aTextureCoord.x, 1.0 - aTextureCoord.y);

    rate2 = uRate * uRate;
    rate3 = rate2 * uRate;
    rateRev = 1.0-uRate;

    float x = -uRate;
    // 0.0001 防止/0
    xr = 0.12 * (x * x * x + 1.) + 0.0001;

    texCoord = v_originTexCoord;
    texCoord.x *= u_aspect_ratio;

    vec2 posC = vec2(0.5+0.023*sin(uTime), 0.4+0.02*cos(uTime)) + uCircleOffset;

    vec2 posR =  uRectPos;
    pos = mix(posC, posR, rate2);
    vec2 posR2 = uRect2Pos;
    vec2 posC2 = posC;
    pos2 = mix(posC2, posR2, uRate);

    vp1 = v_originTexCoord - pos;
    vp2 = v_originTexCoord - pos2;
    vp1.x *= u_aspect_ratio;
    vp2.x *= u_aspect_ratio;

    hr = mix(pos, posR2, uRate);

    radius = mix(0.3, uRectCornerRadius, rate2);

    bgRate = uBgBlur * rateRev;

    rectSize = uRectSize;
    rect2Size = uRect2Size;

    if (rectSize.y<0.2){
        float sy = 0.3 * rateRev;
        rectSize.y += sy;
    }
    if (rect2Size.y<0.2){
        float sy = 0.3 * rateRev;
        rect2Size.y += sy;
    }

    hlWidth = mix(0.006, 0.0028, uRate);

    // Constants that can be calculated in vertex shader
    shadowSize = 0.01;
    highlightColor = vec3(1.0, 1.0, 1.0);

    float time = uTime/2.;
    lightDir1 = normalize(vec2(-0.56 * cos(time) - 0.7 * sin(time),
    -0.56 * sin(time) + 0.7 * cos(time)));
    lightDir2 = -lightDir1;

    // 优化: 更多的预计算参数
    shadowIntensity = 0.05;// 阴影强度
    distortSpeed = vec2(2.0, -2.0);// 扰动效果的速度
    distortFreq = 20.0;// 扰动频率
    F0 = 0.04;// 玻璃的基础反射率
    specularPower = 2.;// 高光强度指数
    highlightEdgeSmoothness = 1.;// 高光边缘平滑系数
    glassTransparency = 0.85;// 玻璃透明度
    transitionWidth = 0.35;// 过渡区域宽度
}