#version 300 es

precision mediump float;

in vec2 v_originTexCoord;

uniform sampler2D currentTex;
uniform sampler2D nextTex;
uniform sampler2D dispTex;
uniform int nightEyeProtection;

uniform float rate;
uniform float u_aspect_ratio;

float effectFactor = 0.1;
float uvScale = 0.8;

out vec4 fragColor;

void main() {

    //vec4 color = mix(texture(currentTex, v_originTexCoord), texture(nextTex, v_originTexCoord), rate);

    vec4 disp = texture(dispTex, vec2(uvScale * v_originTexCoord.x, uvScale * v_originTexCoord.y / u_aspect_ratio));

    vec2 dp1 = vec2(v_originTexCoord.x + rate * (disp.r*effectFactor), v_originTexCoord.y);
    vec2 dp2 = vec2(v_originTexCoord.x - (1.0 - rate) * (disp.r*effectFactor), v_originTexCoord.y);

    vec4 color = mix(texture(currentTex, dp1), texture(nextTex, dp2), rate);

    if (nightEyeProtection == 0){
        fragColor = color;
    } else if (nightEyeProtection == 1){
        fragColor = color*vec4(255.0/255., 237.0/255.0, 182.0/255.0, 1.0);
    } else {
        float gray = dot(color.rgb, vec3(0.299, 0.587, 0.114));
        fragColor = vec4(vec3(gray) * 0.9, color.a);
    }
}
