#version 300 es

precision mediump float;

in vec4 aPosition;
in vec2 aTextureCoord;

uniform vec4 u_uv_trans;
uniform float uScale;

out vec2 v_originTexCoord;

void main() {
    float s = uScale;
    vec2 c = vec2(0.5, 0.5);

    mat3 scale = mat3(
    vec3(s, 0.0, c.x*(1.0-s)),
    vec3(0.0, s, c.y*(1.0-s)),
    vec3(0.0, 0.0, 1.0)
    );

    vec3 p = (scale*aPosition.xyz);
    gl_Position = vec4(p, aPosition.w);

    vec2 centeredCoord = aTextureCoord - vec2(0.5, 0.5);
    v_originTexCoord = centeredCoord * vec2(u_uv_trans.x, u_uv_trans.z)
    + vec2(0.5, 0.5) + vec2(u_uv_trans.y, u_uv_trans.w);
}