#version 300 es

precision mediump float;

in vec2 v_originTexCoord;

uniform sampler2D currentTex;
uniform sampler2D nextTex;
uniform int nightEyeProtection;

uniform float rate;

out vec4 fragColor;

void main() {
    vec2 uv = v_originTexCoord;

    vec4 _texture = texture(currentTex, uv);
    vec4 _texture2 = texture(nextTex, uv);

    // 根据 rate 混合两个纹理
    vec4 color = mix(_texture, _texture2, step(0.5, rate));
    if (nightEyeProtection == 0){
        fragColor = color;
    } else if (nightEyeProtection == 1){
        fragColor = color*vec4(255.0/255., 237.0/255.0, 182.0/255.0, 1.0);;
    } else {
        float gray = dot(color.rgb, vec3(0.299, 0.587, 0.114));
        fragColor = vec4(vec3(gray) * 0.9, color.a);
    }
}