#version 300 es

in vec4 aPosition;
in vec3 aNormal;
in vec2 aTextureCoord;

uniform vec4 uTransform;
uniform float uScale;
out vec2 vUV;

void main() {
    float s = 1.0+uScale;
    vec2 c = vec2(0.5, 0.5);

    mat3 scale = mat3(
    vec3(s, 0.0, c.x*(1.0-s)),
    vec3(0.0, s, c.y*(1.0-s)),
    vec3(0.0, 0.0, 1.0)
    );

    vec3 p = (scale*aPosition.xyz);
    gl_Position = vec4(p, aPosition.w);
    vUV = vec2(aTextureCoord.x*uTransform.x+uTransform.y, aTextureCoord.y*uTransform.z+uTransform.w);
}