precision highp float;

uniform sampler2D tex1;
varying vec2 vTextureCoord;

uniform float scale;
uniform int isScaleX;
uniform vec3 color;

void main() {
    vec4 col = vec4(0.0);
    if (isScaleX==1){
        col =  texture2D(tex1, vec2(vTextureCoord.x*(1.0+scale), vTextureCoord.y));
    } else {
        col =  texture2D(tex1, vec2(vTextureCoord.x, vTextureCoord.y*(1.0+scale)-1.0));
    }

    // change color
    float grey = dot(col.rgb, vec3(0.22, 0.707, 0.071))*1.5;
    col.xyz = color*grey;

    col = pow(col, vec4(0.4545));
    gl_FragColor =  col;
}