
export default class authorizeUtils {
	
	static showAuthTipModal = async (authorize) => {
		// #ifdef H5
		if (1 === 1) {
			return true
		}
		// #endif
		
		let compat = plus.android.importClass('androidx.core.content.ContextCompat')
		let context = plus.android.runtimeMainActivity()
		let result = compat.checkSelfPermission(context, authorize)
		console.log(result,context,'context------------------------')
		if (result === 0) return true
		// // 如果已经授权直接返回
		const contentData = {
			['android.permission.ACCESS_FINE_LOCATION']: {
				title: "定位权限说明",
				describe: "便于您使用该功能定位位置，请您确认授权，否则无法使用该功能"
			},
			["android.permission.READ_EXTERNAL_STORAGE"]: {
				title: "相册权限和拍摄权限说明",
				// describe: "便于您使用该功能上传您的照片/图片/视频存储权限及用户实名认证信，请您确认授权，否则无法使用该功能",
				describe: "相机权限：用于拍摄图片作为头像内容；存储权限：用于把拍摄的图片保存到相册并进行裁剪以及将图片上传到服务器"
			},
			["android.permission.CAMERA"]: {
				title: "拍摄权限说明",
				describe: "便于您使用该功能拍摄身份证、头像和图片，请您确认授权，否则无法使用该功能"
			},
			["android.permission.CALL_PHONE"]: {
				title: "拨打电话权限说明",
				describe: "便于您使用该功能拨打商家、客服电话，请您确认授权，否则无法使用该功能"
			},
			// ["android.permission.READ_EXTERNAL_STORAGE"]: {
			// 	title: "存储权限",
			// 	describe: "便于您使用该功能上传您的照片/图片/视频存储权限，请您确认授权，否则无法使用该功能"
			// },
		}
		return new Promise((resolve) => {
			uni.showModal({
				title: contentData[authorize].title,
				content: contentData[authorize].describe,
				success: (res) => {
					resolve(!!res.confirm)
				},
				fail: () => {

				}
			})
		})



	}
	/**
	 * 用户拒绝授权提示手动授权
	 */
	static showManualAuth = async (authorize) => {
		const contentData = {
			['android.permission.ACCESS_FINE_LOCATION']: "获取定位权限失败，请手动打开授权或检查系统定位开关",
			["android.permission.READ_EXTERNAL_STORAGE"]: "获取相册权限失败，请手动打开授权",
			["android.permission.CAMERA"]: "获取拍摄权限失败，请手动打开授权",
			["android.permission.CALL_PHONE"]: "获取拨打电话权限失败，请手动打开授权",
		}
		uni.showModal({
			title: '提示',
			content: contentData[authorize],
			confirmText: "去设置",
			success: (res) => {
				if (res.confirm) {
					uni.openAppAuthorizeSetting({
						success(res) {
							console.log(res);
						}
					});
				}
				if (res.cancel) {
					console.log('用户点击取消');
				}
			}
		});
	}
}