
//＊＊＊＊＊＊＊＊＊h5详情专用＊＊＊＊＊＊＊＊＊＊＊


//顶部导航栏功能按钮的类型
var TOPBAR_USERINFO = 'userinfo';
var TOPBAR_SEARCH = 'search';
var TOPBAR_SIGN = 'sign';
var TOPBAR_SCAN = 'scan';
var TOPBAR_FASTTEXT = 'fasttext';
var TOPBAR_FASTIMAGE = 'fastimage';
var TOPBAR_FASTCAMERA = 'fastcamera';
var TOPBAR_FASTAUDIO = 'fastaudio';
var TOPBAR_WEBAPP = 'webapp';
var TOPBAR_REFRESH = 'refresh';
var TOPBAR_BROWSER = 'browser';
var TOPBAR_COPY = 'copy';
var TOPBAR_SHARE = 'share';
var TOPBAR_ACTION = 'action';

//定义此方法（必须）
function connectSQJavascriptBridge(callback) {
    if (window.AppbymeJavascriptBridge) {
        window.sq = AppbymeJavascriptBridge;
        callback(AppbymeJavascriptBridge)
    } else {
        document.addEventListener('connectAppbymeJavascriptBridge', function() {
            window.sq = AppbymeJavascriptBridge;
            callback(AppbymeJavascriptBridge)
        }, false)
    }
}

Appbyme = {
    toast: function(p) {
    	window.sq.utils.toBridge("toast", {
            text: p.text,
            isLong: (p.isLong == undefined) ? false : (p.isLong ? true : false),
            success: p.success,
            error: p.error,
            complete: p.complete
        });
    },

    /**
     * 安卓\iOS原生按钮点击，通知Js
     */
    setOnNativeClickListen: function(func) {
    	window.sq.utils.onNativeClickListen = func;
    },

    /**
     * 分享、收藏、复制链接等工具
     * 点击按钮后success返回的数据：
     * data = {
     *     type: number, // 1: 收藏本帖, 2: 跳转页面, 3: 倒序/正序查看, 4: 复制链接, 5: 查看全部, 6: 浏览器打开
     *     isCancel: boolean // 用户操作过程中，是否取消操作
     * }
     */
    openTopicTool: function(p) {
    	window.sq.utils.toBridge("openTopicTool", {
    		title: p.title, // 分享标题
    		content: p.content, // 分享内容
    		boardId: p.boardId,
    		url: p.url, // 分享URL
    		picUrl: p.picUrl, // 分享图片URL
    		authorId: p.authorId,
    		topicId: p.topicId, // 分享出去帖子ID
    		aid: p.aid, // 分享出去文章ID
    		isFavorited: p.isFavorited, // 当前是否已经收藏了，true: 已经收藏、false: 未收藏
    		isDesc: p.isDesc, // 当前是否是倒序排列，true: 倒序、false: 正序
            success: p.success,
            error: p.error,
            complete: p.complete
        });
    },

    /**
     * 分享
     */
    share2: function(p) {
    	window.sq.utils.toBridge("share2", {
    		type: p.type, // 分享类型，wechat,qq,weibo,facebook,qqzone,wechattimeline,all
    		title: p.title, // 分享标题
    		content: p.content, // 分享内容
    		url: p.url, // 分享URL
    		picUrl: p.picUrl, // 分享图片URL
    		topicId: p.topicId, // 分享出去帖子ID
            aid: p.aid, //分享出去的文章ID
            boardId: p.boardId,
            success: p.success,
            error: p.error,
            complete: p.complete
        });
    },

    /**
     * 可分享类型：["wechat","qq","weibo","facebook","qqzone","wechattimeline"]
     */
    shareTypes: function(p) {
    	window.sq.utils.toBridge("shareTypes", {
            success: p.success,
            error: p.error,
            complete: p.complete
        });
    },

    /**
     * 回复帖子
     * 点击回复发送按钮beforeAsyncProcess返回值：
     * data = {
     *     content: "回复内容",
     *     locationStr: "地理位置信息",
     *     longitude: "经度",
     *     latitude: "纬度",
     *     isOpenLocation: boolean, // 是否开启定位
     *     audioPath: "/storage/emulated/0/mobcent/com.goyoo.mobclient/cache/audio/1474188493403.mp3", // 录音存放本机路径
     *     audioLen: 2, // 录音文件长度
     *     pictures: [file:///storage/emulated/0/DCIM/Screenshots/Screenshot_2016-07-28-11-46-18_com.pili.pldroid.streaming.camera.demo.png, file:///storage/emulated/0/DCIM/Screenshots/Screenshot_2016-07-28-11-46-18_com.pili.pldroid.streaming.camera.demo.png], // 图片存放本机路径
     *     userIds: [336, 517]
     * };
     */
    reply: function(p) {
    	window.sq.utils.toBridge("reply", {
    	    aid: p.aid,//文章ID
    		boardId: p.boardId, // 板块ID
    		topicId: p.topicId, // 帖子ID
    		toReplyId: p.toReplyId, // 引用的回复ID
    		isQuote: p.isQuote, // 是否引用
    		isHide: p.isHide, // 是否隐藏回复框，true: 隐藏回复框、false: 打开回复框
    		beforeAsyncProcess: p.beforeAsyncProcess, // 异步处理前，反馈数据
            success: p.success,
            error: p.error,
            complete: p.complete
        });
    },

    /**
     * 预览图片
     */
    previewImage: function(p) {
    	window.sq.utils.toBridge("previewImage", {
    		urls: p.urls, // 图片地址列表，如：["http://1.jpg", "http://2.jpg", "http://3.jpg", "http://4.jpg", "http://5.jpg"]
    		currUrl: p.currUrl, // 当前展示的图片，如："http://3.jpg"
            success: p.success,
            error: p.error,
            complete: p.complete
        });
    },

    /**
     * 帖子详情页登录
     * 登录后刷新帖子详情页，URL上添加accessToken
     */
    topicLogin: function(p) {
    	window.sq.utils.toBridge("topicLogin", {
            success: p.success,
            error: p.error,
            complete: p.complete
        });
    },

    /**
     * 打开话题帖子列表
     */
    startTalkTopic: function(p) {
    	window.sq.utils.toBridge("startTalkTopic", {
    		topicId: p.topicId,
            success: p.success,
            error: p.error,
            complete: p.complete
        });
    },

    /**
     * 打开帖子列表
     */
    startTopicList: function(p) {
    	window.sq.utils.toBridge("startTopicList", {
    		boardId: p.boardId, // 板块ID
    		forumName: p.forumName, // 板块名
            success: p.success,
            error: p.error,
            complete: p.complete
        });
    }

    /**
     * 播放小视频
     */
    playVideo: function(p) {
    	window.sq.utils.toBridge("playVideo", {
    		type: p.type, // 类型 小视频：smallVideo
    		playUrl: p.playUrl // 播放地址
        });
    }

};
