#version 100

#ifdef GL_ES
precision mediump float;
#endif

uniform sampler2D Texture;
uniform sampler2D TextureBlend;

uniform vec2 resolution;
uniform float mAlpha;
uniform float mTheme;

uniform float mRedius;
uniform vec2 mBubblePosition[6];
uniform float mIsTransIn;
uniform float mImageRatio;

varying vec2 vTextureCoord;

#define BlendOverlay(base, blend) vec3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b))
#define BlendOverlayf(base, blend) (base < 0.5 ? (2.0 * base * blend) : (1.0 - 2.0 * (1.0 - base) * (1.0 - blend)))

#define BlendSoftLight(base, blend) vec3(BlendSoftLightf(base.r, blend.r), BlendSoftLightf(base.g, blend.g), BlendSoftLightf(base.b, blend.b))

#define BlendMultiply(base, blend) (base.rgb * blend)

#define BlendScreen(base, blend) vec3(BlendScreenf(base.r, blend.r), BlendScreenf(base.g, blend.g), BlendScreenf(base.b, blend.b))
#define BlendScreenf(base, blend) (1.0 - ((1.0 - base) * (1.0 - blend)))

#define Circlef(textureCoord, ratio, PosiDiff) (pow((textureCoord.x-0.5+PosiDiff.x)*ratio, 2.0) + pow((textureCoord.y-0.5+PosiDiff.y), 2.0))
#define IsInCircle(value, redius) ((value < pow(redius,2.0)) ? 1.0 : 0.0)

float BlendSoftLightf(float base, float blend) {
    return ((blend < 0.5) ? (2.0 * base * blend + base * base * (1.0 - 2.0 * blend)) : (sqrt(base) * (2.0 * blend - 1.0) + 2.0 * base * (1.0 - blend)));
}

vec4 DrawCircle() {
    vec4 srcColor = texture2D(Texture, vTextureCoord);
    if(mIsTransIn == 1.0 || mIsTransIn == -1.0) {
        float mIsInCircle1 = IsInCircle(Circlef(vTextureCoord.xy, mImageRatio, mBubblePosition[0]), mRedius);
        float mIsInCircle2 = IsInCircle(Circlef(vTextureCoord.xy, mImageRatio, mBubblePosition[1]), mRedius);
        float mIsInCircle3 = IsInCircle(Circlef(vTextureCoord.xy, mImageRatio, mBubblePosition[2]), mRedius);
        float mIsInCircle4 = IsInCircle(Circlef(vTextureCoord.xy, mImageRatio, mBubblePosition[3]), mRedius);
        float mIsInCircle5 = IsInCircle(Circlef(vTextureCoord.xy, mImageRatio, mBubblePosition[4]), mRedius);
        float mIsInCircle6 = IsInCircle(Circlef(vTextureCoord.xy, mImageRatio, mBubblePosition[5]), mRedius);
        if(mIsTransIn == 1.0) {
            if(mIsInCircle1 == 0.0 && mIsInCircle2 == 0.0 && mIsInCircle3 == 0.0 && mIsInCircle4 == 0.0 && mIsInCircle5 == 0.0 && mIsInCircle6 == 0.0)
                discard;
        } else if(mIsTransIn == -1.0) {
            if(mIsInCircle1 == 1.0 || mIsInCircle2 == 1.0 || mIsInCircle3 == 1.0 || mIsInCircle4 == 1.0 || mIsInCircle5 == 1.0 || mIsInCircle6 == 1.0)
                discard;
        }
    }
    srcColor.w = srcColor.w * mAlpha;
    return srcColor;
}

vec4 Theme() {
    vec4 mResultColor;
    vec4 srcColor = DrawCircle();

    if(mTheme > 0.0) {
        vec3 BlandColor = texture2D(TextureBlend, gl_FragCoord.xy/resolution.xy).xyz;
        if(mTheme == 1.0) {
            mResultColor = vec4(BlendOverlay(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 2.0) {
            mResultColor = vec4(BlendMultiply(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 3.0) {
            mResultColor = vec4(BlendScreen(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 4.0) {
            mResultColor = vec4(BlendSoftLight(srcColor, BlandColor), srcColor.w);
        }
    } else {
        mResultColor = srcColor;
    }

    return mResultColor;
}

void main() {
    gl_FragColor = Theme();
}
