#ifdef GL_ES
  precision mediump float;
#endif

uniform sampler2D Texture;
uniform vec4 Color;
uniform float Redius;
uniform float ScreenRatio;

varying vec2 vTextureCoord;

#define Circlef(textureCoord, ratio) (pow((textureCoord.x-0.5)*ratio, 2.0) + pow((textureCoord.y-0.5), 2.0))
#define IsInCircle(value, redius) ((value < pow(redius,2.0)) ? 1.0 : 0.0)

void main() {
    vec4 srcColor = texture2D(Texture, vTextureCoord);

    float mIsInCircle = IsInCircle(Circlef(vTextureCoord.xy, ScreenRatio), Redius) ;
    if(mIsInCircle == 1.0)
        discard;
    else
        srcColor = vec4(Color.r, Color.g, Color.b, Color.a);

    gl_FragColor = srcColor;
}
