#version 100

#ifdef GL_ES
    precision mediump float;
#endif

uniform sampler2D Texture;
uniform sampler2D TextureBlend;

uniform float mSize;
uniform float mTrans;
uniform float mDirect;
uniform float mAlpha;
uniform float mReverse;
uniform float mTheme;
uniform float mIsEmpty;
uniform float mSetBound;
uniform float mBound[2];

varying vec4 vCenter;
uniform vec2 resolution;
varying vec2 vTextureCoord;
varying float vXClipDist;
varying float vYClipDist;

varying float vGXClipDist;
varying float vGYClipDist;

varying float vTXClipDist;
varying float vTYClipDist;

#define BlendOverlay(base, blend) vec3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b))
#define BlendOverlayf(base, blend) (base < 0.5 ? (2.0 * base * blend) : (1.0 - 2.0 * (1.0 - base) * (1.0 - blend)))

#define BlendSoftLight(base, blend) vec3(BlendSoftLightf(base.r, blend.r), BlendSoftLightf(base.g, blend.g), BlendSoftLightf(base.b, blend.b))

#define BlendMultiply(base, blend) (base.rgb * blend)

#define BlendScreen(base, blend) vec3(BlendScreenf(base.r, blend.r), BlendScreenf(base.g, blend.g), BlendScreenf(base.b, blend.b))
#define BlendScreenf(base, blend) (1.0 - ((1.0 - base) * (1.0 - blend)))

float BlendSoftLightf(float base, float blend) {
    return ((blend < 0.5) ? (2.0 * base * blend + base * base * (1.0 - 2.0 * blend)) : (sqrt(base) * (2.0 * blend - 1.0) + 2.0 * base * (1.0 - blend)));
}

vec4 Theme() {
    vec4 mResultColor;
    vec4 srcColor = texture2D(Texture, vTextureCoord);
    srcColor.w = srcColor.w * mAlpha;

    if(mTheme > 0.0) {
        vec3 BlandColor = texture2D(TextureBlend, gl_FragCoord.xy/resolution.xy).xyz;
        if(mTheme == 1.0) {
            mResultColor = vec4(BlendOverlay(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 2.0) {
            mResultColor = vec4(BlendMultiply(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 3.0) {
            mResultColor = vec4(BlendScreen(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 4.0) {
            mResultColor = vec4(BlendSoftLight(srcColor, BlandColor), srcColor.w);
        }
    } else {
        mResultColor = srcColor;
    }

    return mResultColor;
}

void main () {
    float mIsDiscard = 0.0;

    if(mSetBound == 1.0) {
        if(vCenter.x + mBound[0] < vTXClipDist || vCenter.x - mBound[0] > vTXClipDist ||
           vCenter.y + mBound[1] < vTYClipDist || vCenter.y - mBound[1] > vTYClipDist) {
            mIsDiscard = 1.0;
        }
    } else if(mSetBound == 4.0) {
        if(mBound[0] < vTXClipDist) {
            mIsDiscard = 1.0;
        }
    }
    if(mTrans == 1.0 && mIsDiscard == 0.0) {
        float alpha;
        if(vXClipDist < mSize && mDirect == 0.0) {
            alpha = 1.0;
        } else if(vXClipDist > mSize && mDirect == 1.0) {
            alpha = 1.0;
        } else if(vYClipDist > mSize && mDirect == 3.0) {
            alpha = 1.0;
        } else if(vYClipDist < mSize && mDirect == 2.0) {
            alpha = 1.0;
        } else if(vGXClipDist < mSize && mDirect == 4.0) {
            alpha = 1.0;
        } else if((vYClipDist >= mSize || vYClipDist <= -mSize) && mDirect == 5.0) {
            alpha = 1.0;
        } else if(mDirect == 6.0) {
            if(vXClipDist >= 0.0 && vYClipDist > -mSize) {
                alpha = 1.0;
            } else if(vXClipDist < 0.0 && vYClipDist < mSize) {
                alpha = 1.0;
           }
        } else if(abs(vXClipDist) <= mSize && mDirect == 7.0) {
            alpha = 1.0;
        } else if(abs(vYClipDist) <= mSize && mDirect == 8.0) {
            alpha = 1.0;
        } else {
            alpha = 0.0;
        }

        if(mReverse == 1.0) {
            if(alpha == 1.0) {
                mIsDiscard = 1.0;
            }
        } else if(alpha == 0.0) {
            mIsDiscard = 1.0;
        }
    }

    if(mIsDiscard == 1.0) {
        gl_FragColor = vec4(1.0, 1.0, 1.0, 0.0);
    } else if(mIsEmpty == 0.0) {
        gl_FragColor = Theme();
    } else {
        gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);
    }
}