#version 100

#ifdef GL_ES
    precision mediump float;
#endif

uniform sampler2D Texture;
uniform sampler2D TextureBlend;

uniform float mAlpha;
uniform float mProgress;
uniform float mMotion;
uniform float mTheme;

varying vec2 vTextureCoord;
varying vec2 vResolution;

#define BlendOverlay(base, blend) vec3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b))
#define BlendOverlayf(base, blend) (base < 0.5 ? (2.0 * base * blend) : (1.0 - 2.0 * (1.0 - base) * (1.0 - blend)))

#define BlendSoftLight(base, blend) vec3(BlendSoftLightf(base.r, blend.r), BlendSoftLightf(base.g, blend.g), BlendSoftLightf(base.b, blend.b))

#define BlendMultiply(base, blend) (base.rgb * blend)

#define BlendScreen(base, blend) vec3(BlendScreenf(base.r, blend.r), BlendScreenf(base.g, blend.g), BlendScreenf(base.b, blend.b))
#define BlendScreenf(base, blend) (1.0 - ((1.0 - base) * (1.0 - blend)))

float BlendSoftLightf(float base, float blend) {
    return ((blend < 0.5) ? (2.0 * base * blend + base * base * (1.0 - 2.0 * blend)) : (sqrt(base) * (2.0 * blend - 1.0) + 2.0 * base * (1.0 - blend)));
}

vec4 Theme(float alpha) {
    vec4 mResultColor;
    vec4 srcColor = texture2D(Texture, vTextureCoord);

    if(mMotion == 0.0) {
        srcColor.w = srcColor.w * mAlpha;
    }
    else {
        srcColor.w = srcColor.w * alpha;
    }

    if(mTheme > 0.0) {
        vec3 BlandColor = texture2D(TextureBlend, gl_FragCoord.xy/vResolution.xy).xyz;
        if(mTheme == 1.0) {
            mResultColor = vec4(BlendOverlay(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 2.0) {
            mResultColor = vec4(BlendMultiply(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 3.0) {
            mResultColor = vec4(BlendScreen(srcColor, BlandColor), srcColor.w);
        } else if(mTheme == 4.0) {
            mResultColor = vec4(BlendSoftLight(srcColor, BlandColor), srcColor.w);
        }
    } else {
        mResultColor = srcColor;
    }

    return mResultColor;
}

float setAlpha(float startTime, float endTime, float now) {
    float alpha;

    if(mMotion == 1.0) {
        if(now < startTime) {
            alpha = 0.0;
        }
        else if(now > endTime) {
            alpha = 1.0;
        }
        else {
            alpha = (now - startTime) / (endTime - startTime);
        }
    }
    else if(mMotion == 2.0) {
        if(now < startTime) {
            alpha = 1.0;
        }
        else if(now > endTime) {
            alpha = 0.0;
        }
        else {
            alpha = 1.0 - (now - startTime) / (endTime - startTime);
        }
    }

    return alpha;
}

void main ()
{
    float alpha = 1.0;

    if(mMotion == 1.0) {
        if(int(gl_FragCoord.x - gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0 - (vResolution.y - 1.0))
        && int(gl_FragCoord.x + gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0)) {
            alpha = setAlpha(0.0, 3.0, mProgress);
        }
        else if(int(gl_FragCoord.x - gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0)
        && int(gl_FragCoord.x + gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0 + (vResolution.y - 1.0))) {
            alpha = setAlpha(1.0, 4.0, mProgress);
        }
        else if(int(gl_FragCoord.x - gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0 - (vResolution.y - 1.0))
        && int(gl_FragCoord.x + gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0)) {
            alpha = setAlpha(2.0, 5.0, mProgress);
        }
        else if(int(gl_FragCoord.x - gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0 - (vResolution.y - 1.0))
        && int(gl_FragCoord.x - gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0)
        && int(gl_FragCoord.x + gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0 + (vResolution.y - 1.0))
        && int(gl_FragCoord.x + gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0)) {
            alpha = setAlpha(3.0, 6.0, mProgress);
        }
        else if(int(gl_FragCoord.x - gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0)
        && int(gl_FragCoord.x + gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0 + (vResolution.y - 1.0))) {
            alpha = setAlpha(4.0, 7.0, mProgress);
        }
        else if(int(gl_FragCoord.x - gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0 - (vResolution.y - 1.0))
        && int(gl_FragCoord.x + gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0)) {
            alpha = setAlpha(5.0, 8.0, mProgress);
        }
        else if(int(gl_FragCoord.x - gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0)
        && int(gl_FragCoord.x + gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0 + (vResolution.y - 1.0))) {
            alpha = setAlpha(6.0, 9.0, mProgress);
        }
        else {
            alpha = setAlpha(7.0, 10.0, mProgress);
        }
    }
    else if(mMotion == 2.0) {
        if(int(gl_FragCoord.x - gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0 - (vResolution.y - 1.0))
        && int(gl_FragCoord.x + gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0)) {
            alpha = setAlpha(1.0, 4.0, mProgress);
        }
        else if(int(gl_FragCoord.x - gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0)
        && int(gl_FragCoord.x + gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0 + (vResolution.y - 1.0))) {
            alpha = setAlpha(2.0, 5.0, mProgress);
        }
        else if(int(gl_FragCoord.x - gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0 - (vResolution.y - 1.0))
        && int(gl_FragCoord.x + gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0)) {
            alpha = setAlpha(3.0, 6.0, mProgress);
        }
        else if(int(gl_FragCoord.x - gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0 - (vResolution.y - 1.0))
        && int(gl_FragCoord.x - gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0)
        && int(gl_FragCoord.x + gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0 + (vResolution.y - 1.0))
        && int(gl_FragCoord.x + gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0)) {
            alpha = setAlpha(4.0, 7.0, mProgress);
        }
        else if(int(gl_FragCoord.x - gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0)
        && int(gl_FragCoord.x + gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0 + (vResolution.y - 1.0))) {
            alpha = setAlpha(5.0, 8.0, mProgress);
        }
        else if(int(gl_FragCoord.x - gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0 - (vResolution.y - 1.0))
        && int(gl_FragCoord.x + gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0)) {
            alpha = setAlpha(6.0, 9.0, mProgress);
        }
        else if(int(gl_FragCoord.x - gl_FragCoord.y) > int((vResolution.x - 1.0) / 2.0)
        && int(gl_FragCoord.x + gl_FragCoord.y) < int((vResolution.x - 1.0) / 2.0 + (vResolution.y - 1.0))) {
            alpha = setAlpha(7.0, 10.0, mProgress);
        }
        else {
            alpha = setAlpha(0.0, 3.0, mProgress);
        }
    }

    if(alpha == 0.0) {
        gl_FragColor = vec4(1.0, 1.0, 1.0, 0.0);
    } else {
        gl_FragColor = Theme(alpha);
    }
}

